//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function C = %hm_m_hm(A,B)
// test pour identifier le type de produit

// Declarations:


// Code:

if (size(A.dims,'*')==3 & size(B.dims,'*')==3) then
  produit = "hm * hm";
elseif (size(A.dims,'*')==3 & size(B.dims,'*')==2) then
  produit = "hm * scal";
end
select produit
  case "hm * hm"
    [l c n]=size(A);
    coherence=sum([l c n]==size(B))==3;
  if(coherence)
    if (l==3 & c==3)
      C = hypermat([l c n],[A(1,1,:).*B(1,1,:) + A(1,2,:).*B(2,1,:) + A(1,3,:).*B(3,1,:);
               A(2,1,:).*B(1,1,:) + A(2,2,:).*B(2,1,:) + A(2,3,:).*B(3,1,:);
               A(3,1,:).*B(1,1,:) + A(3,2,:).*B(2,1,:) + A(3,3,:).*B(3,1,:);
           A(1,1,:).*B(1,2,:) + A(1,2,:).*B(2,2,:) + A(1,3,:).*B(3,2,:);
               A(2,1,:).*B(1,2,:) + A(2,2,:).*B(2,2,:) + A(2,3,:).*B(3,2,:);
               A(3,1,:).*B(1,2,:) + A(3,2,:).*B(2,2,:) + A(3,3,:).*B(3,2,:);
           A(1,1,:).*B(1,3,:) + A(1,2,:).*B(2,3,:) + A(1,3,:).*B(3,3,:);
               A(2,1,:).*B(1,3,:) + A(2,2,:).*B(2,3,:) + A(2,3,:).*B(3,3,:);
               A(3,1,:).*B(1,3,:) + A(3,2,:).*B(2,3,:) + A(3,3,:).*B(3,3,:)]);
    else
      [lA,cA,nA]=size(A); [lB,cB,nB]=size(B);
      if (nA~=nB) | (cA~=lB)
        CL__error("verifier dims des hypermat. en entree");
      end
      C=matrix(zeros(lA*cB*nA,1),[lA cB nA]);
      for ii=1:A.dims(1)
        for jj=1:B.dims(2)
          C(ii,jj,:)=sum(matrix(A(ii,:,:),[cA nA]).*matrix(B(:,jj,:),[lB nA]),1);
        end
      end
    end
  else
     CL__error("Hypermatrices should be of same size");
    end

  case "hm * scal"
  // cas general A = hm la x ca x na , B matrice ca x na
    [la  ca na]=size(A);
    [lb  nb]=size(B);
    B=matrix(B,lb,nb);
    coherence=(ca==lb & na==nb);
    if (coherence) then
      C = zeros(la,nb);
      for i=1:la,
        C(i,:)=sum(matrix(A(i,:,:),lb,nb).*B,'r');
      end
    else
      CL__error("check input hypermat. dims");
    end

end

endfunction
